import { Component, OnInit, Input } from '@angular/core';
import { ConceptServices } from '../../../services/concept-services';
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../../../store';
import { Response } from '@angular/http';
import {
	CONCEPT_CARD_POPULATING,
  ENABLE_CONCEPT_CARD_VIEW,
  SET_CARD_DATA,
  SET_CURRENT_CONCEPT_SELECTED,
  NEW_CONCEPT_HISTORY,
  CONCEPT_CARD_POPULATED
} from '../../../actions';

@Component({
  selector: 'app-concept-card-mvp',
  templateUrl: './concept-card-mvp.component.html',
  styleUrls: ['./concept-card-mvp.component.scss']
})
export class ConceptCardMvpComponent implements OnInit {
	@Input() mvp;

  constructor(
  	private ngRedux: NgRedux<IAppState>,
  	private conceptServices: ConceptServices) { }

  ngOnInit() {
  }

  getState() {
  	return this.ngRedux.getState();
  }

  anyExist(array) {
  	return array.length > 0;
  }

  getConcept(uri) {
	  this.ngRedux.dispatch({
	    type: CONCEPT_CARD_POPULATING
	  });
	  this.ngRedux.dispatch({
	    type: ENABLE_CONCEPT_CARD_VIEW
	  });
	  /* Note: change this method to call populateConceptCard() after API property for URI is in sync */
	  this.conceptServices
	  .populateConceptCard(null, uri)
	  .subscribe(
	    (response: Response) => {
	      if (response.status === 200) {
	        let rdata = JSON.parse(response.text());
	        this.ngRedux.dispatch({
	          type: SET_CARD_DATA,
	          payload: rdata.response
	        });
	        this.ngRedux.dispatch({
	          type: SET_CURRENT_CONCEPT_SELECTED,
	          payload: rdata.response
	        });
	        this.ngRedux.dispatch({
	          type: NEW_CONCEPT_HISTORY,
	          payload: rdata.response
	        });
	        this.ngRedux.dispatch({
	          type: CONCEPT_CARD_POPULATED
	        });
	      }
	    });
  }



}
